// Plik implementacji klasy FeetInches
#include <cstdlib>  // Instrukcja wymagana przez funkcj abs()
#include "FeetInches.h"

//**************************************************************
// Definicja funkcji simplify(). Funkcja ta sprawdza,
// czy warto zmiennej inches jest wiksza od 12 lub
// mniejsza od 0. Jeeli jeden z warunkw jest speniony,
// liczba cali i stp jest dostosowywana do wymogw
// systemu miar. Na przykad miara 3 stopy i 14 cali
// jest zamieniana na 4 stopy i 2 cale, a miara 5 stp
// i -2 cale jest zamieniana na 4 stopy i 10 cali.
//**************************************************************

void FeetInches::simplify()
{
  if (inches >= 12)
  {
    feet += (inches / 12);
    inches = inches % 12;
  }
  else if (inches < 0)
  {
    feet -= ((abs(inches) / 12) + 1);
    inches = 12 - (abs(inches) % 12);
  }
}

//**********************************************
// Przeciony operator jednoargumentowy +
//**********************************************

FeetInches FeetInches::operator + (const FeetInches &right)
{
  FeetInches temp;

  temp.inches = inches + right.inches;
  temp.feet = feet + right.feet;
  temp.simplify();
  return temp;
}

//**********************************************
// Przeciony operator jednoargumentowy -
//**********************************************

FeetInches FeetInches::operator - (const FeetInches &right)
{
  FeetInches temp;

  temp.inches = inches - right.inches;
  temp.feet = feet - right.feet;
  temp.simplify();
  return temp;
}
